--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Tire Sound
    Version: 1.0.0.0 (FS22)
    Date: January 2023
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]

local modDescXMLFile = loadXMLFile("modDescXMLFile", g_currentModDirectory .. "modDesc.xml")
local defaultVolumeConfig = Utils.getNoNil(getXMLFloat(modDescXMLFile, "modDesc.volumeSetting#defaultVolumeConfigPercent"), 1)
delete(modDescXMLFile)

if defaultVolumeConfig == 40 then
    defaultVolumeConfig = 2
elseif defaultVolumeConfig == 50 then
    defaultVolumeConfig = 3
elseif defaultVolumeConfig == 65 then
    defaultVolumeConfig = 4
elseif defaultVolumeConfig == 80 then
    defaultVolumeConfig = 5
elseif defaultVolumeConfig == 100 then
    defaultVolumeConfig = 6
elseif defaultVolumeConfig == 125 then
    defaultVolumeConfig = 7
elseif defaultVolumeConfig == 150 then
    defaultVolumeConfig = 8
elseif defaultVolumeConfig == 175 then
    defaultVolumeConfig = 9
elseif defaultVolumeConfig == 200 then
    defaultVolumeConfig = 10
elseif defaultVolumeConfig == 250 then
    defaultVolumeConfig = 11
elseif defaultVolumeConfig == 300 then
    defaultVolumeConfig = 12
end

if g_specializationManager:getSpecializationByName("tireSound") == nil then
    g_specializationManager:addSpecialization('tireSound', 'tireSound', Utils.getFilename('tireSound.lua', g_currentModDirectory), nil)
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(tireSound, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Wheels, vehicleType.specializations) then
    elseif vehicleTypeName == 'tractor' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    elseif vehicleTypeName == 'tractorCrabSteering' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    elseif vehicleTypeName == 'tractorReverseDriving' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    elseif vehicleTypeName == 'tractorReverseDrivingCrabSteering' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    elseif vehicleTypeName == 'selfPropelledSprayer' then
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    elseif SpecializationUtil.hasSpecialization(ConveyorBelt, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Locomotive, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(MixerWagon, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Combine, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Pipe, vehicleType.specializations) then
    elseif vehicleTypeName == 'selfPropelledMower' then
    elseif vehicleTypeName == 'woodHarvester' then
    elseif vehicleTypeName == 'teleHandler' then
    elseif vehicleTypeName == 'woodTruck' then
    elseif vehicleTypeName == 'forwarder' then
    else
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'tireSound')
    end 
end

function initNewStoreConfig()
    --print("initNewStoreConfig =================================")
    g_configurationManager:addConfigurationType("tireSound", g_i18n:getText("CONFIG_TITLE"), nil, nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION)
	StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, addNewStoreConfig)
end

function addNewStoreConfig(xmlFile, superFunc, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
	local configurations = superFunc(xmlFile, baseXMLName, baseDir, customEnvironment, isMod, storeItem)
    
    local category = ""
    if storeItem == nil then
    elseif configurations == nil then
    elseif configurations["tireSound"] ~= nil then
    else
        category = string.sub(storeItem.categoryName, 1, 8)
    end
    
    if category == "TRACTORS" or category == "SPRAYERV" or category == "TRUCKS" or category == "U400" then
        --print("addNewStoreConfig ==============================")
        --print(storeItem.categoryName)
        
        local xmlFile = XMLFile.load("vehicle", storeItem.xmlFilename, Vehicle.xmlSchema)
        local maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile.handle, "vehicle.motorized.motorConfigurations.motorConfiguration(%d).motor#maxForwardSpeed"), 0)
        local integrateConfig = true
        if storeItem.isMod == false then
            if category == "TRUCKS" then
                integrateConfig = false
            end
        else
            if category == "TRUCKS" then
                local modName = getXMLString(xmlFile.handle, "vehicle.storeData.name")
                if modName == nil then
                    modName = getXMLString(xmlFile.handle, "vehicle.storeData.name.en")
                end
                if modName == nil then
                    integrateConfig = false
                elseif string.find(string.upper(modName), "UNIMOG") == nil then
                    integrateConfig = false
                end
                if modName == "$l10n_storeData_name_1axis" then  -- Unimog U5023
                    integrateConfig = true
                end
            end
        end
        delete(xmlFile.handle)

        if maxSpeed > 29 and integrateConfig == true then
            local name1 = g_i18n:getText("CONFIG_NAME1")
            local name2 = g_i18n:getText("CONFIG_NAME2")
            local name3 = g_i18n:getText("CONFIG_NAME3")
            local name4 = g_i18n:getText("CONFIG_NAME4")
            local name5 = g_i18n:getText("CONFIG_NAME5")
            local name6 = g_i18n:getText("CONFIG_NAME6")
            local name7 = g_i18n:getText("CONFIG_NAME7")
            local name8 = g_i18n:getText("CONFIG_NAME8")
            local name9 = g_i18n:getText("CONFIG_NAME9")
            local name10 = g_i18n:getText("CONFIG_NAME10")
            local name11 = g_i18n:getText("CONFIG_NAME11")
            local name12 = g_i18n:getText("CONFIG_NAME12")
            configurations["tireSound"] = {
                {name = name1, index = 1, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name2, index = 2, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name3, index = 3, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name4, index = 4, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name5, index = 5, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name6, index = 6, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name7, index = 7, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name8, index = 8, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name9, index = 9, isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name10,index = 10,isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name11,index = 11,isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true},
                {name = name12,index = 12,isDefault = false, price = 0, dailyUpkeep = 0, isSelectable = true}
            }
            defaultVolumeConfig = math.floor(defaultVolumeConfig + 0.5)
            if defaultVolumeConfig < 1 or defaultVolumeConfig > 12 then
                configurations["tireSound"][1].isDefault = true
            else
                configurations["tireSound"][defaultVolumeConfig].isDefault = true
            end
        end
    end
    
    return configurations
end


if g_configurationManager.configurations["tireSound"] == nil then
    initNewStoreConfig()
end
