﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
---@v1.1.1.1----------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("src/realDirtColorTracks.lua", g_currentModDirectory));

function installSpec()
	if g_specializationManager:getSpecializationByName("realDirtColorTracks") == nil then
		if realDirtColorTracks == nil then 
			print("ERROR: unable to find source file 'realDirtColorTracks.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;
					local isAnimated = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "washable" then 
							isWashable = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isWashable and isAnimated then
						 if typeDef.specializationsByName["realDirtColorTracks"] == nil then
							table.insert(typeDef.specializations, realDirtColorTracks);
							table.insert(typeDef.specializationNames, "realDirtColorTracks");
							typeDef.specializationsByName["realDirtColorTracks"] = realDirtColorTracks;
						end;
					end;
				end;
			end;
		end;	
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);