-- Aircraft AddOn Main
-- Version 1.0.0.0
-- @author Vector Man
-- @date 2022-12-16
-- copyright (c) Vector Man, All Rights Reserved

source(g_currentModDirectory .. "src/ExhaustExtensionMenu.lua")

local environment

local function load(mission)
    assert(g_exhaustExtensionMenu == nil)

    environment = ExhaustExtensionMenu:new(mission, g_i18n, g_currentModDirectory, g_currentModName)

    getfenv(0)["g_exhaustExtensionMenu"] = environment

    addModEventListener(environment)
end

local function unload()
    removeModEventListener(environment)
    environment = nil
    getfenv(0)["g_exhaustExtensionMenu"] = nil
end

local function startMission(mission)
    environment:onMissionStart(mission)
end

local function init()
    FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)

    Mission00.load = Utils.prependedFunction(Mission00.load, load)
    Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, startMission)

    InGameMenuGameSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGameSettingsFrame.onFrameOpen, ExhaustExtensionMenu.initSettingsMenu)
    InGameMenuGameSettingsFrame.updateGameSettings = Utils.appendedFunction(InGameMenuGameSettingsFrame.updateGameSettings, ExhaustExtensionMenu.updateSettingsMenu)
end

init()