--
-- Vehicle Info for FS22
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0 - 2021-12-07 - conversion to FS22
--
VehicleInfo = {};
VehicleInfo.confDir = getUserProfileAppPath().. "modsSettings/VehicleInfo/";
VehicleInfo.modDirectory = g_currentModDirectory
local modName = g_currentModName

function VehicleInfo.prerequisitesPresent(specializations)
    return true
end


function VehicleInfo.registerOverwrittenFunctions(vehicleType)
end

function VehicleInfo.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "saveToXmlVehicleInfo", 	VehicleInfo.saveToXmlVehicleInfo)
	SpecializationUtil.registerFunction(vehicleType, "loadFromXmlVehicleInfo", 	VehicleInfo.loadFromXmlVehicleInfo)
	SpecializationUtil.registerFunction(vehicleType, "updateHudValues", 		VehicleInfo.updateHudValues)
	SpecializationUtil.registerFunction(vehicleType, "resetTrip", 				VehicleInfo.resetTrip)
	SpecializationUtil.registerFunction(vehicleType, "updateFuel", 				VehicleInfo.updateFuel)
	SpecializationUtil.registerFunction(vehicleType, "activateMod", 			VehicleInfo.activateMod)
end

function VehicleInfo:registerActionEventsPlayer()
end

function VehicleInfo:onRegisterActionEvents(isSelected, isOnActiveVehicle)
	local spec = self.spec_vehicleInfo
	
	if spec.event_IDs == nil then
		spec.event_IDs = {}
	end
	
	local entered = true
    if self.getIsEntered ~= nil then
        entered = self:getIsEntered()
    end
	
	if self:getIsActiveForInput(true, true) and entered then
		self:loadFromXmlVehicleInfo(self:getFullName())
		self:updateHudValues()
		if g_dedicatedServerInfo ~= nil then
			return
		end
		local actions = { InputAction.VEHICLEINFO_RESET_TRIP, InputAction.VEHICLEINFO_TOGGLE_FUEL, InputAction.VEHICLEINFO_MOVE_HUD_TRIGGER, InputAction.VEHICLEINFO_MOVE_HUD_LEFT, InputAction.VEHICLEINFO_MOVE_HUD_RIGHT,
								InputAction.VEHICLEINFO_MOVE_HUD_UP, InputAction.VEHICLEINFO_MOVE_HUD_DOWN, InputAction.VEHICLEINFO_TOGGLE_SIZE, InputAction.VEHICLEINFO_TOGGLE_HELP, InputAction.VEHICLEINFO_TOGGLE, InputAction.VEHICLEINFO_TOGGLE_ALL }
		for _,actionName in pairs(actions) do
			local always = (actionName == InputAction.VEHICLEINFO_MOVE_HUD_TRIGGER or actionName == InputAction.VEHICLEINFO_MOVE_HUD_LEFT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_RIGHT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_UP or actionName == InputAction.VEHICLEINFO_MOVE_HUD_DOWN) and true or false
			local _, eventID = g_inputBinding:registerActionEvent(actionName, self, VehicleInfo.actionCallback, true, true, always, true)
			spec.event_IDs[actionName] = eventID
			if g_inputBinding ~= nil and g_inputBinding.events ~= nil and g_inputBinding.events[eventID] ~= nil then
				if actionName == InputAction.VEHICLEINFO_MOVE_HUD_LEFT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_RIGHT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_UP or actionName == InputAction.VEHICLEINFO_MOVE_HUD_DOWN
					or actionName == InputAction.VEHICLEINFO_MOVE_HUD_TRIGGER then
					g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_NORMAL)
				else
					g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_VERY_HIGH)
				end
				if actionName == InputAction.VEHICLEINFO_TOGGLE_HELP then
					g_inputBinding:setActionEventTextVisibility(eventID, true)
				elseif actionName == InputAction.VEHICLEINFO_TOGGLE or actionName == InputAction.VEHICLEINFO_TOGGLE_ALL then
					g_inputBinding:setActionEventTextVisibility(eventID, false)
				else
					g_inputBinding:setActionEventTextVisibility(eventID, VehicleInfo.showHelp)
				end
			end
		end
	end
end
function VehicleInfo.registerEventListeners(vehicleType)
	for _,n in pairs( { "onLoad","onPostLoad","onUpdate","onRegisterActionEvents","onDraw","saveToXmlVehicleInfo","loadFromXmlVehicleInfo","onReadStream","onWriteStream","updateHudValues" } ) do
		SpecializationUtil.registerEventListener(vehicleType, n, VehicleInfo)
	end
end
function VehicleInfo:onLoad(savegame)
	self.spec_vehicleInfo = {}
	local spec = self.spec_vehicleInfo
	local xmlFile = self.xmlFile
	spec.event_IDs = {}
	
	spec.hudDistance = createImageOverlay(VehicleInfo.modDirectory .. "images\\hudDistanceNew.dds")
	spec.hudDistance2 = createImageOverlay(VehicleInfo.modDirectory .. "images\\hudDistance2.dds")
	spec.hudFuel = createImageOverlay(VehicleInfo.modDirectory .. "images\\iconFuel.dds")
	spec.hudTemp = createImageOverlay(VehicleInfo.modDirectory .. "images\\iconTemp.dds")
	spec.numberOverlays = {{},{},{},{},{},{}}
	spec.numberOverlaysTrip = {{},{},{},{}}
	for i = 1,6,1 do
		for ii = 0,9,1 do
			spec.numberOverlays[i][ii] = createImageOverlay(VehicleInfo.modDirectory .. "images\\"..ii..".dds")
			if i == 6 then
				setOverlayColor(spec.numberOverlays[i][ii], 1, 0, 0, 1)
			end
		end
	end
	for i = 1,4,1 do
		for ii = 0,9,1 do
			spec.numberOverlaysTrip[i][ii] = createImageOverlay(VehicleInfo.modDirectory .. "images\\"..ii..".dds")
			if i == 4 then
				setOverlayColor(spec.numberOverlaysTrip[i][ii], 1, 0, 0, 1)
			end
		end
	end
	spec.ui = g_gameSettings.uiScale
	
	
	spec.distance = 0
	spec.distTravelTotal = 0
	spec.distTravelTrip = 0
	spec.operatingTimeTotal = 0
	spec.operatingTimeTrip = 0
	spec.fuelCapacity = 0
	spec.fuelCurrent = 0
	spec.fuelUsedTotal = {0,0}
	spec.fuelUsedTrip = {0,0}
	spec.fuelUsage = {0,0}
	spec.fuelUsageTotal = {0,0}
	spec.fuelUsageTrip = {0,0}
	spec.fuelUsageKmOld = 0
	spec.diffTemp = {}
	spec.hudTextDistance1 = ''
	spec.hudTextDistance2 = ''
	spec.hudTextDistance3 = ''
	spec.hudTextFuel1 = ''
	spec.hudTextFuel2 = ''
	spec.hudTextFuel3 = ''
	spec.hudTextFuel4 = ''
	spec.hudTextTemp = ''
	spec.fuelTimer = 0
	spec.fuelUsedBuffer2 = {}
	spec.distanceBuffer2 = {}
	spec.numbers = {"0","0","0","0","0","0","0"}
	spec.numbersTrip = {"0","0","0","0","0"}
	spec.timerHud = 0
	spec.moveHudTrigger = false
	spec.fuelDiff = 0
	spec.modActive = true
	spec.fuelCurrent2 = 0
	
	VehicleInfo.showHelp = true
	VehicleInfo.size = 1
	VehicleInfo.maxSize = 1.4
	VehicleInfo.minSize = 0.8
	VehicleInfo.shiftX = 0.0688
	VehicleInfo.shiftY = 0.8377
	VehicleInfo.usageType = 1
	VehicleInfo.modActive = true
end
function VehicleInfo:onPostLoad(savegame)
	local spec = self.spec_vehicleInfo
	local xmlFile = self.xmlFile
	if spec.event_IDs == nil then
		spec.event_IDs = {}
	end
	
	if savegame ~= nil then
		local xmlFile = savegame.xmlFile.handle
		local key = savegame.key.."."..modName..".VehicleInfo"
		spec.distTravelTotal = Utils.getNoNil(getXMLFloat(xmlFile, key.."#distTravelTotal"), spec.distTravelTotal);
		spec.distTravelTrip = Utils.getNoNil(getXMLFloat(xmlFile, key.."#distTravelTrip"), spec.distTravelTrip);
		spec.fuelUsedTotal[1] = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsedTotalKm"), spec.fuelUsedTotal[1]);
		spec.fuelUsedTotal[2] = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsedTotalL"), spec.fuelUsedTotal[2]);
		spec.fuelUsedTrip[1] = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsedTripKm"), spec.fuelUsedTrip[1]);
		spec.fuelUsedTrip[2] = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsedTripL"), spec.fuelUsedTrip[2]);
		spec.operatingTimeTotal = Utils.getNoNil(getXMLFloat(xmlFile, key.."#operatingTimeTotal"), spec.operatingTimeTrip);
		spec.operatingTimeTotal = spec.operatingTimeTotal * 1000
		spec.operatingTimeTrip = Utils.getNoNil(getXMLFloat(xmlFile, key.."#operatingTimeTrip"), spec.operatingTimeTrip);
		spec.operatingTimeTrip = spec.operatingTimeTrip * 1000
	end
	
	if self.isClient and g_dedicatedServerInfo == nil then
		local configFile = VehicleInfo.confDir .. "VehicleInfoConfig.xml";
		if fileExists(configFile) then
			self:loadFromXmlVehicleInfo(self:getFullName());
		else
			createFolder(getUserProfileAppPath().. "modsSettings/");
			createFolder(VehicleInfo.confDir);
			VehicleInfo.configXml = createXMLFile("VehicleInfo_XML", configFile, "VehicleInfoConfig");
			self:saveToXmlVehicleInfo();
		end
	end
	self:updateFuel(nil, nil, nil, nil, nil, true)
	self:updateHudValues()
end
function VehicleInfo:updateHudValues()
	local spec = self.spec_vehicleInfo
	
	spec.sizeHud = VehicleInfo.size * spec.ui
	spec.positionX = g_currentMission.inGameMenu.hud.speedMeter.gaugeCenterX - VehicleInfo.shiftX
	spec.positionY = g_currentMission.inGameMenu.hud.speedMeter.gaugeCenterX - VehicleInfo.shiftY
	spec.hudDistanceWidthNew = 0.075 * spec.sizeHud
	spec.hudDistanceHeightNew = 0.19 * spec.sizeHud
	spec.hudDistanceX = spec.positionX - spec.hudDistanceWidthNew
	spec.hudDistanceY = spec.positionY
	spec.distancePosX = spec.hudDistanceX - (0.001 * spec.sizeHud)
	spec.distancePosY = spec.hudDistanceY + (0.0664 * spec.sizeHud)
	spec.distancePosTripX = spec.hudDistanceX - (0.001 * spec.sizeHud)
	spec.distancePosTripY = spec.hudDistanceY + (0.0187 * spec.sizeHud)
	spec.numOverlayWidth = 0.008 * spec.sizeHud;
	spec.numOverlayHeight = 0.0203 * spec.sizeHud;
	spec.NumPosXs = {0.01,0.02,0.03,0.04,0.05,0.06}
	spec.NumPosYs = {0,0.002,0.004,0.006,0.008,0.01,0.012,0.014,0.016,0.018}
	spec.NumPosTripXs = {0.03,0.04,0.05,0.06}
	spec.hudFuelX = spec.hudDistanceX + (0.0054 * spec.sizeHud)
	spec.hudFuelY = spec.hudDistanceY + (0.1593 * spec.sizeHud)
	spec.hudFuelWidth = 0.014 * spec.sizeHud
	spec.hudFuelHeight = 0.024 * spec.sizeHud
	spec.hudTextDistance2X = spec.hudDistanceX + (0.065 * spec.sizeHud)
	spec.hudTextDistance2Y = spec.hudDistanceY + (0.0547 * spec.sizeHud)
	spec.hudTextDistance1X = spec.hudTextDistance2X - (0.018 * spec.sizeHud)
	spec.hudTextDistance1Y = spec.hudTextDistance2Y - (0.005 * spec.sizeHud)
	spec.hudTextDistance3X = spec.hudDistanceX + (0.004 * spec.sizeHud)
	spec.hudTextDistance3Y = spec.hudDistanceY + (0.0242 * spec.sizeHud)
	spec.hudTextFuel1X = spec.hudFuelX + (0.0405 * spec.sizeHud)
	spec.hudTextFuel1Y = spec.hudFuelY + (0.0139 * spec.sizeHud)
	spec.hudTextFuel2X = spec.hudFuelX - (0.003 * spec.sizeHud)
	spec.hudTextFuel2Y = spec.hudFuelY - (0.0238 * spec.sizeHud)
	spec.hudTextFuel3X = spec.hudTextFuel2X + (0.069 * spec.sizeHud)
	spec.hudTextFuel3Y = spec.hudTextFuel2Y
	spec.hudTempX = spec.hudDistanceX + (0.003 * spec.sizeHud)
	spec.hudTempY = spec.hudDistanceY + (0.093 * spec.sizeHud)
	spec.hudTempWidth = 0.008 * spec.sizeHud
	spec.hudTempHeight = 0.017 * spec.sizeHud
	spec.hudTextTempX = spec.hudTempX + (0.009 * spec.sizeHud)
	spec.hudTextTempY = spec.hudTempY + (0.004 * spec.sizeHud)
end
function VehicleInfo:saveToXMLFile(xmlFile, key)
	local spec = self.spec_vehicleInfo
	
	setXMLFloat(xmlFile.handle, key.."#distTravelTotal", spec.distTravelTotal)
	setXMLFloat(xmlFile.handle, key.."#distTravelTrip", spec.distTravelTrip)
	setXMLFloat(xmlFile.handle, key.."#fuelUsedTotalKm", spec.fuelUsedTotal[1])
	setXMLFloat(xmlFile.handle, key.."#fuelUsedTotalL", spec.fuelUsedTotal[2])
	setXMLFloat(xmlFile.handle, key.."#fuelUsedTripKm", spec.fuelUsedTrip[1])
	setXMLFloat(xmlFile.handle, key.."#fuelUsedTripL", spec.fuelUsedTrip[2])
	setXMLFloat(xmlFile.handle, key.."#operatingTimeTotal", spec.operatingTimeTotal / 1000)
	setXMLFloat(xmlFile.handle, key.."#operatingTimeTrip", spec.operatingTimeTrip / 1000)
end
function VehicleInfo:loadFromXmlVehicleInfo(vehicle)
	local spec = self.spec_vehicleInfo
	
	local configFile = VehicleInfo.confDir .. "VehicleInfoConfig.xml";
    if self.isClient and g_dedicatedServerInfo == nil and fileExists(configFile) then
		VehicleInfo.configXml = loadXMLFile("VehicleInfo_XML", configFile);
		if getXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.showHelp") ~= nil then
			VehicleInfo.showHelp = getXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.showHelp")
		end
		if getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftX") ~= nil then
			VehicleInfo.shiftX = getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftX")
		end
		if getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftY") ~= nil then
			VehicleInfo.shiftY = getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftY")
		end
		if getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.size") ~= nil then
			VehicleInfo.size = getXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.size")
		end
		if getXMLInt(VehicleInfo.configXml, "VehicleInfoConfig.usageType") ~= nil then
			VehicleInfo.usageType = getXMLInt(VehicleInfo.configXml, "VehicleInfoConfig.usageType")
		end
		if getXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.modActive") ~= nil then
			VehicleInfo.modActive = getXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.modActive")
		end
		if vehicle ~= nil then
			local key = "VehicleInfoConfig.activeVehicles"
			local i = 0
			while true do
				local name = getXMLString(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i).."#name");
				if name ~= nil then
					if name == vehicle then
						spec.modActive = getXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i));
						break
					end
				else
					break
				end
				i = i + 1
			end
		end
	end
end
function VehicleInfo:saveToXmlVehicleInfo(vehicle, active)
	local spec = self.spec_vehicleInfo
    
	if self.isClient and VehicleInfo.configXml ~= nil and g_dedicatedServerInfo == nil then
		setXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.showHelp", VehicleInfo.showHelp)
		setXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftX", VehicleInfo.shiftX)
		setXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.shiftY", VehicleInfo.shiftY)
		setXMLFloat(VehicleInfo.configXml, "VehicleInfoConfig.size", VehicleInfo.size)
		setXMLInt(VehicleInfo.configXml, "VehicleInfoConfig.usageType", VehicleInfo.usageType)
		setXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.modActive", VehicleInfo.modActive)
		if vehicle ~= nil and active ~= nil then
			local key = "VehicleInfoConfig.activeVehicles"
			local i = 0
			while true do
				local name = getXMLString(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i).."#name")
				if name ~= nil then
					if name == vehicle then
						setXMLString(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i).."#name", vehicle)
						setXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i), active)
						break
					end
				else
					setXMLString(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i).."#name", vehicle)
					setXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i), active)
					break
				end
				i = i + 1
				local name = key .. string.format(".vehicle(%d)", i)
				if not hasXMLProperty(VehicleInfo.configXml, name) then
					setXMLString(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i).."#name", vehicle)
					setXMLBool(VehicleInfo.configXml, "VehicleInfoConfig.activeVehicles"..string.format(".vehicle(%d)", i), active)
					break
				end
			end
		end
		saveXMLFile(VehicleInfo.configXml)
	end
end
function VehicleInfo:onUpdate(dt, vehicle)
	local spec = self.spec_vehicleInfo
	
	if (self.spec_motorized.isMotorStarted or self:getIsActive()) and spec.modActive and VehicleInfo.modActive then
		self:raiseActive()
		spec.distance = 0
		local fuelDiff = 0
		local usageType = VehicleInfo.usageType
		if self.movingDirection ~= 0 then
			local x,y,z = getWorldTranslation(self.rootNode)
			if spec.xTemp == nil or spec.xTemp == 0 then
				spec.xTemp, spec.yTemp, spec.zTemp = x,y,z
			end
			spec.distance =  MathUtil.vector3Length(spec.xTemp-x, spec.yTemp-y, spec.zTemp-z)
			spec.xTemp, spec.yTemp, spec.zTemp = x,y,z
			spec.distTravelTotal = spec.distTravelTotal + spec.distance
			spec.distTravelTrip = spec.distTravelTrip + spec.distance
			if spec.distTravelTotal / 1000 > 99999.99 then
				spec.distTravelTotal = 0
				spec.fuelUsedTotal[1] = 0
			end
			if spec.distTravelTrip / 1000 > 999.99 then
				spec.distTravelTrip = 0
				spec.fuelUsedTrip[1] = 0
			end
		end
		local km = string.format("%.2f",spec.distTravelTotal / 1000)
		if tonumber(km) > 99999.99 then
			km = "99999.99"
		end
		if tonumber(km) < 10 then
			km = "0000"..km
		elseif tonumber(km) < 100 then
			km = "000"..km
		elseif tonumber(km) < 1000 then
			km = "00"..km
		elseif tonumber(km) < 10000 then
			km = "0"..km
		end
		for i = 1, 7, 1 do
			local ii = i;
			if(ii > 5) then
				ii = (ii+1)
			end;
			spec.numbers[i] = tonumber(string.sub(km,ii,ii))
		end
		local km = string.format("%.2f",spec.distTravelTrip / 1000)
		if tonumber(km) > 999.99 then
			km = "999.99"
		end
		if tonumber(km) < 10 then
			km = "00"..km
		elseif tonumber(km) < 100 then
			km = "0"..km
		end
		for i = 1, 5, 1 do
			local ii = i;
			if(ii > 3) then
				ii = (ii+1)
			end;
			spec.numbersTrip[i] = tonumber(string.sub(km,ii,ii))
		end
		-------------------------------------------------------------------------------		FUEL CONSUMPTION		-------------------------------------------------------------
		if self.spec_fillUnit ~= nil and self.spec_motorized.isMotorStarted then
			spec.operatingTimeTrip = spec.operatingTimeTrip + dt
			spec.operatingTimeTotal = spec.operatingTimeTotal + dt
				for i, fillUnit in ipairs(self.spec_fillUnit.fillUnits) do
					if fillUnit.fillType == 37 then
					  spec.fuelCapacity = fillUnit.capacity
					  spec.fuelCurrent = fillUnit.fillLevel
					end
				end
				if spec.fuelCurrent2 == nil or spec.fuelCurrent2 == 0 then
					spec.fuelCurrent2 = spec.fuelCurrent
				end
				if self.isServer then
					if spec.fuelTemp2 == nil or spec.fuelTemp2 == 0 then
						spec.fuelTemp2 = spec.fuelCurrent
					end
					spec.fuelDiff = (self.spec_motorized.lastFuelUsage * dt) / (3600 * 1000)
					if spec.fuelTemp2 == spec.fuelCurrent then
						if not g_currentMission.missionInfo.helperBuyFuel or not self:getIsAIActive() then
							spec.fuelCurrent2 = spec.fuelCurrent2 - spec.fuelDiff
						end
						table.insert(spec.fuelUsedBuffer2, spec.fuelDiff)
					else
						spec.fuelTemp2 = spec.fuelCurrent
						spec.fuelCurrent2 = spec.fuelCurrent
					end
					table.insert(spec.distanceBuffer2, spec.distance)
					spec.fuelTimer = spec.fuelTimer + dt
					if spec.fuelTimer > 250 then
						spec.fuelTimer = 0
						local fuelUsedTotal = 0
						for _,fuel in ipairs(spec.fuelUsedBuffer2) do
							fuelUsedTotal = fuelUsedTotal + fuel
						end
						local fuelUsedAvg = fuelUsedTotal / #spec.fuelUsedBuffer2
						local distanceTotal = 0
						for _,dist in ipairs(spec.distanceBuffer2) do
							distanceTotal = distanceTotal + dist
						end
						local distanceAvg = distanceTotal / #spec.distanceBuffer2
						self:updateFuel(fuelUsedTotal, fuelUsedAvg, self.spec_motorized.lastFuelUsageDisplay, distanceAvg, spec.fuelCurrent2, false)
						spec.fuelUsedBuffer2 = {}
						spec.distanceBuffer2 = {}
					end
				end
		else
			spec.fuelUsage[1] = 0
			spec.fuelUsage[2] = 0
		end
	end
		--[[if self:getIsActive() then
		spec.infoText2 = "";
		spec.infoText2 = spec.infoText2 .. 'fuelTemp2 -    '..spec.fuelTemp2..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelCurrent - '..spec.fuelCurrent..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelCurrent2 - '..spec.fuelCurrent2..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelDiff - '..string.format('%.7f',spec.fuelDiff)..'\n'
		spec.infoText2 = spec.infoText2 .. 'spec.distance - '..string.format('%.7f',spec.distance)..'\n\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageKmCurr - '..string.format('%.1f',spec.fuelUsage[1])..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageKmTotal - '..string.format('%.2f',spec.fuelUsageTotal[1])..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageKmTrip - '..string.format('%.2f',spec.fuelUsageTrip[1])..'\n\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageLCurr - '..string.format('%.1f',spec.fuelUsage[2])..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageLCurrDisp - '..string.format('%.1f',self.spec_motorized.lastFuelUsageDisplay)..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageLCurr - '..string.format('%.1f',self.spec_motorized.lastFuelUsage)..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageLTotal - '..string.format('%.2f',spec.fuelUsageTotal[2])..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsageLTrip - '..string.format('%.2f',spec.fuelUsageTrip[2])..'\n\n'
		spec.infoText2 = spec.infoText2 .. 'operatingTimeTotal - '..string.format('%.1f',spec.operatingTimeTotal/1000)..'\n'
		spec.infoText2 = spec.infoText2 .. 'operatinTimeTrip - '..string.format('%.1f',spec.operatingTimeTrip/1000)..'\n'
		spec.infoText2 = spec.infoText2 .. 'distTravelTotal - '..spec.distTravelTotal..'\n'
		spec.infoText2 = spec.infoText2 .. 'distTravelTrip - '..spec.distTravelTrip..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsedTotal1 - '..spec.fuelUsedTotal[1]..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsedTrip1 - '..spec.fuelUsedTrip[1]..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsedTotal2 - '..spec.fuelUsedTotal[2]..'\n'
		spec.infoText2 = spec.infoText2 .. 'fuelUsedTrip2 - '..spec.fuelUsedTrip[2]..'\n\n'
		spec.infoText2 = spec.infoText2 .. 'eventActive - '..tostring(VehicleInfo.eventActive)..'\n'
		spec.infoText2 = spec.infoText2 .. 'modActive - '..tostring(VehicleInfo.modActive)..'\n'
		spec.infoText2 = spec.infoText2 .. 'modActiveSpec - '..tostring(spec.modActive)..'\n'
		spec.infoText2 = spec.infoText2 .. 'moveHudTrigger - '..tostring(spec.moveHudTrigger)..'\n'
		spec.infoText2 = spec.infoText2 .. 'buffer2 - '..#spec.fuelUsedBuffer2..'\n'
		spec.infoText2 = spec.infoText2 .. 'helperBuyFuel - '..tostring(g_currentMission.missionInfo.helperBuyFuel)..'\n'
		renderText(0.7080, 0.8205, 0.017, spec.infoText2)
		end]]
	if self.isClient then
		if self:getIsControlled() then
			if spec.event_IDs ~= nil and g_dedicatedServerInfo == nil then
				local sizeText = VehicleInfo.size == 0.8 and g_i18n:getText('VEHICLEINFO_HUD_SMALL') or (VehicleInfo.size == 1 and g_i18n:getText('VEHICLEINFO_HUD_NORMAL') or (VehicleInfo.size == 1.2 and g_i18n:getText('VEHICLEINFO_HUD_LARGE') or (VehicleInfo.size == 1.4 and g_i18n:getText('VEHICLEINFO_HUD_LARGER') or g_i18n:getText('VEHICLEINFO_HUD_CUSTOM'))))
				g_inputBinding:setActionEventText(spec.event_IDs['VEHICLEINFO_TOGGLE_FUEL'], VehicleInfo.usageType == 1 and g_i18n:getText('VEHICLEINFO_SWITCH_FUEL_TO_HOUR') or g_i18n:getText('VEHICLEINFO_SWITCH_FUEL_TO_KM'))
				g_inputBinding:setActionEventText(spec.event_IDs['VEHICLEINFO_TOGGLE_SIZE'], g_i18n:getText('VEHICLEINFO_TOGGLE_SIZE')..' : '..sizeText)
				g_inputBinding:setActionEventText(spec.event_IDs['VEHICLEINFO_TOGGLE_HELP'], VehicleInfo.showHelp and g_i18n:getText('VEHICLEINFO_HELP_HIDE') or g_i18n:getText('VEHICLEINFO_HELP_SHOW'))
				g_inputBinding:setActionEventText(spec.event_IDs['VEHICLEINFO_RESET_TRIP'], g_i18n:getText('VEHICLEINFO_RESET_TRIP'))
				for actionName,eventID in pairs(spec.event_IDs) do
					if actionName == InputAction.VEHICLEINFO_TOGGLE_HELP then
						g_inputBinding:setActionEventTextVisibility(eventID, true)
					elseif actionName == InputAction.VEHICLEINFO_MOVE_HUD_TRIGGER then
						g_inputBinding:setActionEventTextVisibility(eventID, not spec.moveHudTrigger)
					elseif actionName == InputAction.VEHICLEINFO_TOGGLE or actionName == InputAction.VEHICLEINFO_TOGGLE_ALL then
						g_inputBinding:setActionEventTextVisibility(eventID, false)
					else
						g_inputBinding:setActionEventTextVisibility(eventID, VehicleInfo.showHelp)
					end
				
					if actionName == InputAction.VEHICLEINFO_TOGGLE or actionName == InputAction.VEHICLEINFO_TOGGLE_ALL then
						g_inputBinding:setActionEventActive(eventID, true)
					elseif actionName == InputAction.VEHICLEINFO_MOVE_HUD_LEFT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_RIGHT or actionName == InputAction.VEHICLEINFO_MOVE_HUD_UP or actionName == InputAction.VEHICLEINFO_MOVE_HUD_DOWN then
						g_inputBinding:setActionEventActive(eventID, spec.moveHudTrigger and spec.modActive and VehicleInfo.modActive)
					else
						g_inputBinding:setActionEventActive(eventID, spec.modActive and VehicleInfo.modActive)
					end
				end
			end
		end
		if spec.inputLeft or spec.inputRight or spec.inputUp or spec.inputDown then
			local x = VehicleInfo.shiftX
			local y = VehicleInfo.shiftY
			spec.timerHud = spec.timerHud + dt
			if spec.inputLeft then
				if spec.timerHud > 1500 then
					x = x + 0.001
				else
					x = x + 0.0001
				end
			end
			if spec.inputRight then
				if spec.timerHud > 1500 then
					x = x - 0.001
				else
					x = x - 0.0001
				end
			end
			if spec.inputUp then
				if spec.timerHud > 1500 then
					y = y - 0.001
				else
					y = y - 0.0001
				end
			end
			if spec.inputDown then
				if spec.timerHud > 1500 then
					y = y + 0.001
				else
					y = y + 0.0001
				end
			end
			VehicleInfo.shiftX = x
			VehicleInfo.shiftY = y
			self:updateHudValues()
		else
			spec.timerHud = 0
		end
	end
end
function VehicleInfo:onDraw()
	local spec = self.spec_vehicleInfo
	
	if self.isClient and self:getIsControlled() and spec.modActive and VehicleInfo.modActive then
		renderOverlay(spec.hudDistance2, spec.hudDistanceX, spec.hudDistanceY, spec.hudDistanceWidthNew, spec.hudDistanceHeightNew)
		for i = -6, -1, 1 do
			local i2 = math.abs(i)
			for ii = 0, 9, 1 do
				if (ii == spec.numbers[i2]) then
					local posY = 0
					if i2 == 6 then
						posY = spec.numbers[i2+1]
					end	
					local shift = true
					for n = 1, (6-i2), 1 do
						if spec.numbers[i2+n] ~= 9 then
							shift = false
						end
					end
					if shift then
						posY = spec.numbers[7]
					end
					posY = posY + 1
					renderOverlay(spec.numberOverlays[i2][ii], spec.distancePosX + (spec.NumPosXs[i2]*spec.sizeHud), spec.distancePosY + (spec.NumPosYs[posY]*spec.sizeHud), spec.numOverlayWidth, spec.numOverlayHeight)
					if posY ~= 1 then
						posY = 10-posY+2
						renderOverlay(spec.numberOverlays[i2][ii < 9 and ii+1 or 0], spec.distancePosX + (spec.NumPosXs[i2]*spec.sizeHud), spec.distancePosY - (spec.NumPosYs[posY]*spec.sizeHud), spec.numOverlayWidth, spec.numOverlayHeight)
					end
					break
				end
			end
		end
		for i = -4, -1, 1 do
			local i2 = math.abs(i)
			for ii = 0, 9, 1 do
				if (ii == spec.numbersTrip[i2]) then
					local posY = 0
					if i2 == 4 then
						posY = spec.numbersTrip[i2+1]
					end
					local shift = true
					for n = 1, (4-i2), 1 do
						if spec.numbersTrip[i2+n] ~= 9 then
							shift = false
						end
					end
					if shift then
						posY = spec.numbersTrip[5]
					end
					posY = posY + 1
					renderOverlay(spec.numberOverlaysTrip[i2][ii], spec.distancePosTripX + (spec.NumPosTripXs[i2]*spec.sizeHud), spec.distancePosTripY + (spec.NumPosYs[posY]*spec.sizeHud), spec.numOverlayWidth, spec.numOverlayHeight)
					if posY ~= 1 then
						posY = 10-posY+2
						renderOverlay(spec.numberOverlaysTrip[i2][ii < 9 and ii+1 or 0], spec.distancePosTripX + (spec.NumPosTripXs[i2]*spec.sizeHud), spec.distancePosTripY - (spec.NumPosYs[posY]*spec.sizeHud), spec.numOverlayWidth, spec.numOverlayHeight)
					end
					break
				end
			end
		end
		renderOverlay(spec.hudDistance, spec.hudDistanceX, spec.hudDistanceY, spec.hudDistanceWidthNew, spec.hudDistanceHeightNew)
		renderOverlay(spec.hudFuel, spec.hudFuelX, spec.hudFuelY, spec.hudFuelWidth, spec.hudFuelHeight)
		renderOverlay(spec.hudTemp, spec.hudTempX, spec.hudTempY, spec.hudTempWidth, spec.hudTempHeight)
		setTextBold(false);
		
		setTextColor(1, 1, 1, 1)
		spec.hudTextDistance1 = spec.hudTextDistance1 .. 'km'
		spec.hudTextDistance2 = spec.hudTextDistance2 .. 'm\n'
		spec.hudTextDistance2 = spec.hudTextDistance2 .. 'x100'
		spec.hudTextDistance3 = spec.hudTextDistance3 .. 'TRIP'
		spec.hudTextFuel1 = spec.hudTextFuel1 .. string.format('%.1f',spec.fuelUsage[1]) .. ' l/100km\n'
		spec.hudTextFuel1 = spec.hudTextFuel1 .. string.format('%.1f',spec.fuelUsage[2]) .. ' l/h'
		spec.hudTextFuel2 = spec.hudTextFuel2 .. 'Total:\nTrip:'
		spec.hudTextFuel3 = spec.hudTextFuel3 .. string.format('%.1f',spec.fuelUsageTotal[VehicleInfo.usageType])
		if VehicleInfo.usageType == 1 then
			spec.hudTextFuel3 = spec.hudTextFuel3 .. ' l/100km\n'
		elseif VehicleInfo.usageType == 2 then
			spec.hudTextFuel3 = spec.hudTextFuel3 .. ' l/h\n'
		end
		spec.hudTextFuel3 = spec.hudTextFuel3 .. string.format('%.1f',spec.fuelUsageTrip[VehicleInfo.usageType])
		if VehicleInfo.usageType == 1 then
			spec.hudTextFuel3 = spec.hudTextFuel3 .. ' l/100km\n\n'
		elseif VehicleInfo.usageType == 2 then
			spec.hudTextFuel3 = spec.hudTextFuel3 .. ' l/h\n\n'
		end
		spec.hudTextFuel4 = spec.hudTextFuel4 .. string.format('%.1f', spec.fuelCurrent2)..' l/'..string.format('%.0f', spec.fuelCapacity)..' l'
		spec.hudTextTemp = string.format('%.0f',self.spec_motorized.motorTemperature.value)..'°C\n'
		setTextAlignment(RenderText.ALIGN_CENTER)
		setTextBold(true)
		setTextColor(1, 0, 0, 1)
		renderText(spec.hudTextDistance2X, spec.hudTextDistance2Y, 0.01*spec.sizeHud, spec.hudTextDistance2)
		setTextBold(false)
		setTextColor(1, 1, 1, 1)
		renderText(spec.hudTextFuel1X, spec.hudTextFuel1Y, 0.013*spec.sizeHud, spec.hudTextFuel1);
		setTextAlignment(RenderText.ALIGN_RIGHT);
		renderText(spec.hudTextFuel3X, spec.hudTextFuel3Y, 0.012*spec.sizeHud, spec.hudTextFuel3);
		renderText(spec.hudTextFuel3X, spec.hudTextTempY, 0.011*spec.sizeHud, spec.hudTextFuel4);
		setTextAlignment(RenderText.ALIGN_LEFT);
		renderText(spec.hudTextFuel2X, spec.hudTextFuel2Y, 0.012*spec.sizeHud, spec.hudTextFuel2);
		renderText(spec.hudTextDistance1X, spec.hudTextDistance1Y, 0.012*spec.sizeHud, spec.hudTextDistance1);
		renderText(spec.hudTextDistance3X, spec.hudTextDistance3Y, 0.015*spec.sizeHud, spec.hudTextDistance3);
		renderText(spec.hudTextTempX, spec.hudTextTempY, 0.011*spec.sizeHud, spec.hudTextTemp);
		spec.hudTextDistance1 = ''
		spec.hudTextDistance2 = ''
		spec.hudTextDistance3 = ''
		spec.hudTextFuel1 = ''
		spec.hudTextFuel2 = ''
		spec.hudTextFuel3 = ''
		spec.hudTextFuel4 = ''
		spec.hudTextTemp = ''
	end
end
function VehicleInfo:resetTrip(noEventSend)
	local spec = self.spec_vehicleInfo
	
	spec.distTravelTrip = 0
	spec.fuelUsedTrip = {0,0}
	spec.fuelUsageTrip = {0,0}
	spec.operatingTimeTrip = 0
	VehicleInfoResetTripEvent.sendEvent(self, noEventSend)
end
function VehicleInfo:updateFuel(fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2, noEventSend)
	local spec = self.spec_vehicleInfo
	
	spec.fuelCurrent2 = fuelCurrent2
	if g_currentMission.missionInfo.helperBuyFuel and self:getIsAIActive() and false then
		spec.fuelUsedTotal[1] = (spec.fuelUsageTotal[1] * (spec.distTravelTotal / 1000)) / 100
		spec.fuelUsedTrip[1] = (spec.fuelUsageTrip[1] * (spec.distTravelTrip / 1000)) / 100
		spec.fuelUsedTotal[2] = spec.fuelUsageTotal[2] * (spec.operatingTimeTotal / 1000 / 60 / 60)
		spec.fuelUsedTrip[2] = spec.fuelUsageTrip[2] * (spec.operatingTimeTrip / 1000 / 60 / 60)
		spec.fuelUsage[1] = 0
		spec.fuelUsage[2] = 0
	else
		if fuelUsedTotal ~= nil and fuelUsedAvg ~= nil and fuelUsageH ~= nil then
			if self.movingDirection ~= 0 then
				spec.fuelUsedTotal[1] = spec.fuelUsedTotal[1] + fuelUsedTotal
				spec.fuelUsedTrip[1] = spec.fuelUsedTrip[1] + fuelUsedTotal
			end
			spec.fuelUsedTotal[2] = spec.fuelUsedTotal[2] + fuelUsedTotal
			spec.fuelUsedTrip[2] = spec.fuelUsedTrip[2] + fuelUsedTotal
			if spec.distance ~= 0 and spec.distance > 0.01 then
				spec.fuelUsage[1] = (fuelUsedAvg * 100) / (distanceAvg / 1000)
			else
				spec.fuelUsage[1] = 0
			end
			spec.fuelUsage[2] = fuelUsageH
		end
	end
	
	if spec.distTravelTotal ~= 0 and spec.distTravelTotal > 0.5 and (spec.distance > 0.0002 or fuelUsedTotal == nil) then			---------------------zkusit mensi distance kvuli hrabani
		spec.fuelUsageTotal[1] = (spec.fuelUsedTotal[1] * 100) / (spec.distTravelTotal / 1000)
	end
	if spec.distTravelTrip ~= 0 and spec.distTravelTrip > 0.5 and (spec.distance > 0.0002 or fuelUsedTotal == nil) then
		spec.fuelUsageTrip[1] = (spec.fuelUsedTrip[1] * 100) / (spec.distTravelTrip / 1000)
	end
	if spec.operatingTimeTotal ~= 0 then
		spec.fuelUsageTotal[2] = spec.fuelUsedTotal[2] / (spec.operatingTimeTotal / 1000 / 60 / 60)
	end
	if spec.operatingTimeTrip ~= 0 then
		spec.fuelUsageTrip[2] = spec.fuelUsedTrip[2] / (spec.operatingTimeTrip / 1000 / 60 / 60)
	end
	
	if self.spec_fillUnit ~= nil then
		for i, fillUnit in ipairs(self.spec_fillUnit.fillUnits) do
			if fillUnit.fillType == 37 then
			  spec.fuelCapacity = fillUnit.capacity
			  spec.fuelCurrent = fillUnit.fillLevel
			end
		end
	end
	VehicleInfoUpdateFuelEvent.sendEvent(self, fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2, noEventSend)
end
function VehicleInfo:actionCallback(actionName, keyStatus, arg4, arg5, arg6)
	local spec = self.spec_vehicleInfo
	
	if keyStatus > 0 then
		if actionName == 'VEHICLEINFO_RESET_TRIP' then
			self:resetTrip(false)
		elseif actionName == 'VEHICLEINFO_TOGGLE_FUEL' then
			VehicleInfo.usageType = (VehicleInfo.usageType == 1 and 2 or 1)
			self:saveToXmlVehicleInfo()
		elseif actionName == 'VEHICLEINFO_TOGGLE_SIZE' then
			if VehicleInfo.size + 0.2 <= VehicleInfo.maxSize then
				VehicleInfo.size = VehicleInfo.size + 0.2
			else
				VehicleInfo.size = VehicleInfo.minSize
			end
			self:saveToXmlVehicleInfo()
			self:updateHudValues()
		elseif actionName == 'VEHICLEINFO_TOGGLE_HELP' then
			VehicleInfo.showHelp = not VehicleInfo.showHelp
			self:saveToXmlVehicleInfo()
		elseif actionName == 'VEHICLEINFO_TOGGLE' then
			if VehicleInfo.modActive == false then
				g_currentMission:showBlinkingWarning("FIRST ACTIVATE VEHICLE INFO MOD GLOBAL (CTRL + ALT + V)")
			else
				spec.modActive = not spec.modActive
				self:activateMod(spec.modActive, 'THIS')
				self:saveToXmlVehicleInfo(self:getFullName(), spec.modActive)
			end
		elseif actionName == 'VEHICLEINFO_TOGGLE_ALL' then
			VehicleInfo.modActive = not VehicleInfo.modActive
			self:activateMod(VehicleInfo.modActive, 'ALL')
			self:saveToXmlVehicleInfo()
		end
	end
	if actionName == 'VEHICLEINFO_MOVE_HUD_TRIGGER' then
		spec.moveHudTrigger = keyStatus > 0
	elseif actionName == 'VEHICLEINFO_MOVE_HUD_LEFT' then
		spec.inputLeft = keyStatus > 0
		if keyStatus == 0 then self:saveToXmlVehicleInfo() end
	elseif actionName == 'VEHICLEINFO_MOVE_HUD_RIGHT' then
		spec.inputRight = keyStatus > 0
		if keyStatus == 0 then self:saveToXmlVehicleInfo() end
	elseif actionName == 'VEHICLEINFO_MOVE_HUD_UP' then
		spec.inputUp = keyStatus > 0
		if keyStatus == 0 then self:saveToXmlVehicleInfo() end
	elseif actionName == 'VEHICLEINFO_MOVE_HUD_DOWN' then
		spec.inputDown = keyStatus > 0
		if keyStatus == 0 then self:saveToXmlVehicleInfo() end
	else
		spec.moveHudTrigger = false
	end
end
function VehicleInfo:activateMod(status, mode)
	local spec = self.spec_vehicleInfo
	
	if mode == 'THIS' then
		mode = self:getFullName()
	end
	local text = 'ACTIVATED'
	if not status then
		text = 'DEACTIVATED'
	end
	g_currentMission:showBlinkingWarning("VEHICLE INFO FUNCTIONS "..tostring(text).." FOR "..tostring(mode).." VEHICLES", 2000);
	spec.fuelTemp2 = 0
	spec.xTemp, spec.yTemp, spec.zTemp = 0,0,0
end
function VehicleInfo:onReadStream(streamId, connection)
	local spec = self.spec_vehicleInfo
	
	local distTravelTotal = streamReadFloat32(streamId)
	local distTravelTrip = streamReadFloat32(streamId)
	local fuelUsedTotal1 = streamReadFloat32(streamId)
	local fuelUsedTotal2 = streamReadFloat32(streamId)
	local fuelUsedTrip1 = streamReadFloat32(streamId)
	local fuelUsedTrip2 = streamReadFloat32(streamId)
	local operatingTimeTotal = streamReadFloat32(streamId)
	local operatingTimeTrip = streamReadFloat32(streamId)
	if distTravelTotal ~= nil and distTravelTrip ~= nil and fuelUsedTotal1 ~= nil and fuelUsedTotal2 ~= nil and fuelUsedTrip1 ~= nil and fuelUsedTrip2 ~= nil and operatingTimeTotal ~= nil and operatingTimeTrip ~= nil then
		spec.distTravelTotal = distTravelTotal
		spec.distTravelTrip = distTravelTrip
		spec.fuelUsedTotal[1] = fuelUsedTotal1
		spec.fuelUsedTotal[2] = fuelUsedTotal2
		spec.fuelUsedTrip[1] = fuelUsedTrip1
		spec.fuelUsedTrip[2] = fuelUsedTrip2
		spec.operatingTimeTotal = operatingTimeTotal
		spec.operatingTimeTrip = operatingTimeTrip
		self:updateFuel(nil, nil, nil, nil, nil, true)
	end
end;
function VehicleInfo:onWriteStream(streamId, connection)
	local spec = self.spec_vehicleInfo
	streamWriteFloat32(streamId, spec.distTravelTotal)
	streamWriteFloat32(streamId, spec.distTravelTrip)
	streamWriteFloat32(streamId, spec.fuelUsedTotal[1])
	streamWriteFloat32(streamId, spec.fuelUsedTotal[2])
	streamWriteFloat32(streamId, spec.fuelUsedTrip[1])
	streamWriteFloat32(streamId, spec.fuelUsedTrip[2])
	streamWriteFloat32(streamId, spec.operatingTimeTotal)
	streamWriteFloat32(streamId, spec.operatingTimeTrip)
end;

--- Events ---
VehicleInfoUpdateFuelEvent = {}
VehicleInfoUpdateFuelEvent_mt = Class(VehicleInfoUpdateFuelEvent, Event)

InitEventClass(VehicleInfoUpdateFuelEvent, "VehicleInfoUpdateFuelEvent")

function VehicleInfoUpdateFuelEvent.emptyNew()
    local self = Event.new(VehicleInfoUpdateFuelEvent_mt)
    return self
end
    
function VehicleInfoUpdateFuelEvent.new(object, fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2)
	local self = VehicleInfoUpdateFuelEvent.emptyNew()
	self.object = object
	self.fuelUsedTotal = fuelUsedTotal
	self.fuelUsedAvg = fuelUsedAvg
	self.fuelUsageH = fuelUsageH
	self.distanceAvg = distanceAvg
	self.fuelCurrent2 = fuelCurrent2
	return self
end

function VehicleInfoUpdateFuelEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.fuelUsedTotal = streamReadFloat32(streamId)
	self.fuelUsedAvg = streamReadFloat32(streamId)
	self.fuelUsageH = streamReadFloat32(streamId)
	self.distanceAvg = streamReadFloat32(streamId)
	self.fuelCurrent2 = streamReadFloat32(streamId)
	self:run(connection)
end

function VehicleInfoUpdateFuelEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteFloat32(streamId, self.fuelUsedTotal)
	streamWriteFloat32(streamId, self.fuelUsedAvg)
	streamWriteFloat32(streamId, self.fuelUsageH)
	streamWriteFloat32(streamId, self.distanceAvg)
	streamWriteFloat32(streamId, self.fuelCurrent2)
end

function VehicleInfoUpdateFuelEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object)
	end;
	if self.object ~= nil then
		self.object:updateFuel(self.fuelUsedTotal, self.fuelUsedAvg, self.fuelUsageH, self.distanceAvg, self.fuelCurrent2, true)
	end
end

function VehicleInfoUpdateFuelEvent.sendEvent(vehicle, fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2, noEventSend)
	if fuelUsedTotal ~= vehicle.fuelUsedTotal and fuelUsedAvg ~= vehicle.fuelUsedAvg and fuelUsageH ~= vehicle.fuelUsageH and distanceAvg ~= vehicle.distanceAvg and fuelCurrent2 ~= vehicle.fuelCurrent2 then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(VehicleInfoUpdateFuelEvent.new(vehicle, fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2), nil, nil, vehicle)
			else
				g_client:getServerConnection():sendEvent(VehicleInfoUpdateFuelEvent.new(vehicle, fuelUsedTotal, fuelUsedAvg, fuelUsageH, distanceAvg, fuelCurrent2))
			end
		end
	end
end

VehicleInfoResetTripEvent = {}
VehicleInfoResetTripEvent_mt = Class(VehicleInfoResetTripEvent, Event)

InitEventClass(VehicleInfoResetTripEvent, "VehicleInfoResetTripEvent")

function VehicleInfoResetTripEvent.emptyNew()
    local self = Event.new(VehicleInfoResetTripEvent_mt)
    return self
end
    
function VehicleInfoResetTripEvent.new(object)
	local self = VehicleInfoResetTripEvent.emptyNew()
	self.object = object
	return self
end

function VehicleInfoResetTripEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self:run(connection)
end

function VehicleInfoResetTripEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
end

function VehicleInfoResetTripEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object)
	end;
	if self.object ~= nil then
		self.object:resetTrip(true)
	end
end

function VehicleInfoResetTripEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(VehicleInfoResetTripEvent.new(vehicle), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(VehicleInfoResetTripEvent.new(vehicle))
		end
	end
end