--
-- Vehicle Info for FS22
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0 - 2021-12-07 - conversion to FS22
--
local modDirectory = g_currentModDirectory or ""
local modName = g_currentModName or "unknown"

source(modDirectory .. "vehicleInfo.lua")

local function initSpecialization(manager)
    if manager.typeName == "vehicle" then
        g_specializationManager:addSpecialization("vehicleInfo", "VehicleInfo", modDirectory .. "vehicleInfo.lua", nil)

        for typeName, typeEntry in pairs(g_vehicleTypeManager:getTypes()) do
			if typeEntry ~= nil and typeName ~= "locomotive" and typeName ~= "trainTrailer" and typeName ~= "trainTimberTrailer" then 
				if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations) and SpecializationUtil.hasSpecialization(Enterable, typeEntry.specializations) and SpecializationUtil.hasSpecialization(Motorized, typeEntry.specializations) then
					g_vehicleTypeManager:addSpecialization(typeName, modName .. ".vehicleInfo")
				end
            end
        end
    end
end

local function init()
    TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, initSpecialization)
end

init()
---Helper method for getting the scoped spec table.
--[[function Vehicle:cfcMod_getSpec()
    return self["spec_" .. modName .. ".cultivatorFieldCreator"]
end]]
