﻿-- Author: TeeKoo/Truck-King
-- Name: PositionSaver.lua
-- Description: Functions for detect player enter&exit + saving&loading xml, Function for server to send startpoints to clients

-- Modifications only with my permission, Perkele!

-- Changelog:
--  v1.0.0.1 (2.12.2021)
--		- FS22 Converting
--
--	v1.0.0.0 (24.1.2021)
--		- first release
--
-- 	v0.0.8.0 (23.1.2021):
--	 	- beta test
--		- change player teleporting to client
--		- debug mode
--
-- 	v0.0.5.0 (22.1.2021):
--		- beta test
--		- player position updated when player leaves mission (enters vehicle or landscape mode)
--		- translated log texts
-- 	v0.0.3.0 (20.1.2021):
--		- alpha test
-- ToDo:
--

PositionSaver = {};
PositionSaver.name = "POSITIONSAVER"
PositionSaver.debugMode = false
source(g_currentModDirectory .. "src/PlayerManager.lua")

function PositionSaver.loadMission()
	if g_currentMission:getIsServer() then
		PositionSaver.PlayerManager = PlayerManager:new(PositionSaver.debugMode)
		if  g_currentMission.missionInfo.savegameDirectory ~= nil then
			local savegameFilename = g_currentMission.missionInfo.savegameDirectory .. "/playerPositions.xml"
			if fileExists(savegameFilename) then
				local xmlFile = loadXMLFile("playerPositions", savegameFilename)
				local uniqueUserIdKey = ""
				local xmlKey = ""
				
				local i = 0
				local loaded = 0
				
				while (true) do
					xmlKey = string.format("playerPositions.player(%d)#", i)
					uniqueUserIdKey = xmlKey .. "uniqueUserId"

					if hasXMLProperty(xmlFile, uniqueUserIdKey) then
						local uniqueUserId = getXMLString(xmlFile, uniqueUserIdKey)				
						local x = getXMLFloat(xmlFile, xmlKey.. "x")
						local y = getXMLFloat(xmlFile, xmlKey.. "y")
						local z = getXMLFloat(xmlFile, xmlKey.. "z")
						local name = getXMLString(xmlFile, xmlKey .. "playerName")
						PositionSaver.PlayerManager:updatePlayerPositionWithUq(uniqueUserId, x, y, z, name)
						loaded = loaded + 1
					else
						break
					end
					i = i + 1
				end
				print(string.format("%s: Loaded positions of %d players from the savegame",PositionSaver.name,loaded))
			end
		end
	end
end 

function PositionSaver.saveToXMLFile(missionInfo)
	if PositionSaver.PlayerManager ~= nil then
		local xmlFile = createXMLFile("playerPositions", missionInfo.savegameDirectory .. "/playerPositions.xml", "playerPositions")
		if xmlFile ~= nil then
			print(string.format("%s: Game is being saved, updating the locations of all players", PositionSaver.name))	
			PositionSaver.PlayerManager:savePlayerPositions(xmlFile)
			saveXMLFile(xmlFile)
			delete(xmlFile)
			print(string.format("%s: Updated and saved", PositionSaver.name))
		end
	end
end 

function PositionSaver:loadPlayer(xmlFilename, playerStyle, creatorConnection, isOwner)
	if self.isServer then		
		local name = g_currentMission.userManager:getUserByUserId(self.userId):getNickname()
		local x, y, z = PositionSaver.PlayerManager:getPlayerPosition(self.userId)
		
		if x ~= nil and y ~= nil and z ~= nil then
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 300, z)
			y = math.max(terrainHeight + 0.1, y + 0.9)
			print(string.format("%s: Player '%s' joined. Teleporting to founded position (X:%d, Y:%d, Z:%d)",PositionSaver.name,name,x,y,z))
			self.startX = x
			self.startY = y
			self.startZ = z
			self.savedPosition = true
		else
			print(string.format("%s: Player '%s' joined. Player is new and has not last position",PositionSaver.name,name))			
			self.startX = 0
			self.startY = 0
			self.startZ = 0
			self.savedPosition = false
		end
	end
end

function PositionSaver:onUserQuitGame()
	if PositionSaver.PlayerManager ~= nil then
		print(string.format("%s: Player is trying to exit, updating the locations of all players", PositionSaver.name))	
		PositionSaver.PlayerManager:updatePlayerPositions()
	end
end

function PositionSaver:moveTo(superFunc, x, y, z, isAbsolute, isRootNode)
	if self.isOwner and self.savedPosition then 
		x = self.startX
		y = self.startY
		z = self.startZ
		self.savedPosition = false
	end
	superFunc(self, x, y, z, isAbsolute, isRootNode)
end

function PositionSaver:onLeave()
	if PositionSaver.PlayerManager ~= nil then
		local x,y,z = self:getPositionData()
		if y > -190 then
			local name = g_currentMission.userManager:getUserByUserId(self.userId):getNickname()
			PositionSaver.PlayerManager:updatePlayerPosition(self.userId,x, y, z, name)
			--print(string.format("%s: Player '%s' leaves from current mission, position updated (X:%d, Y:%d, Z:%d)", PositionSaver.name, name, x, y, z))
		-- else
			-- if PositionSaver.debugMode then
				-- print(string.format("%s:ERROR Player '%s' leaves from current mission with position -200", PositionSaver.name, self.visualInformation.playerName))
			-- end
		end
	end
end

function PositionSaver:writeStream(streamId, connection)	
	local isOwner = connection == self.networkInformation.creatorConnection
	if isOwner then
		streamWriteBool(streamId, self.savedPosition)
		if self.savedPosition then
			streamWriteFloat32(streamId, self.startX)
			streamWriteFloat32(streamId, self.startY)
			streamWriteFloat32(streamId, self.startZ)
		end
	end
end

function PositionSaver:readStream(streamId, connection)
	if self.isOwner then
		self.savedPosition = streamReadBool(streamId)
		if self.savedPosition then
			self.startX = streamReadFloat32(streamId)
			self.startY = streamReadFloat32(streamId)
			self.startZ = streamReadFloat32(streamId)
		end
	end
end

function PositionSaver.delete()
	if PositionSaver.PlayerManager ~= nil then
		PositionSaver.PlayerManager:delete()
		PositionSaver.PlayerManager = nil
	end
end

Player.moveTo = Utils.overwrittenFunction(Player.moveTo,PositionSaver.moveTo)
Player.onLeave = Utils.prependedFunction(Player.onLeave, PositionSaver.onLeave);
Player.load = Utils.appendedFunction(Player.load, PositionSaver.loadPlayer);
Player.readStream  = Utils.appendedFunction(Player.readStream, PositionSaver.readStream);
Player.writeStream = Utils.appendedFunction(Player.writeStream, PositionSaver.writeStream);

Farm.onUserQuitGame = Utils.prependedFunction(Farm.onUserQuitGame, PositionSaver.onUserQuitGame);

FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, PositionSaver.delete)
FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, PositionSaver.saveToXMLFile)
Mission00.load = Utils.appendedFunction(Mission00.load, PositionSaver.loadMission)