--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 12.10.2020
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


local buildId = 1
local versionString = "0.0.0.0"

local modName = g_currentModName or ""
local modDirectory = g_currentModDirectory or ""

local validationFail

local function validateTypes(typeManager)
    if typeManager.typeName == "vehicle" then
        g_specializationManager:addSpecialization("rideableFirstPersonCamera", "RideableFirstPersonCamera", Utils.getFilename("scripts/specializations/RideableFirstPersonCamera.lua", modDirectory), nil)

        local specName = string.format("%s.rideableFirstPersonCamera", modName)
        local specialization = g_specializationManager:getSpecializationObjectByName(specName)

        if specialization ~= nil then
            for typeName, typeEntry in pairs(typeManager:getTypes()) do
                if specialization.prerequisitesPresent(typeEntry.specializations) then
                    typeManager:addSpecialization(typeName, specName)
                end
            end
        else
            Logging.warning("Failed to load specialization 'rideableFirstPersonCamera', mod '%s' may not perform as intended!", modName)
        end
    end
end

local function init()
    local mod = g_modManager:getModByName(modName)
    local isValidMod = false

    versionString = mod.version or versionString

    if mod.modName == "FS22_HorseRidingCamera" or mod.modName == "FS22_HorseRidingCamera_update" then
        if mod.author ~= nil and #mod.author == 3 then
            isValidMod = true
        end
    end

    if isValidMod then
        g_rideableFirstPersonCameraModName = modName
        TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, validateTypes)
    else
        validationFail = {
            updateTime = 2000,

            update = function(self, dt)
                self.updateTime = self.updateTime - dt

                if self.updateTime < 0 then
                    local text = string.format(g_i18n:getText("horseRidingCamera_loadError", modName), modName, mod.author or "Unknown")

                    if g_dedicatedServerInfo == nil then
                        if not g_gui:getIsGuiVisible() then
                            g_gui:showYesNoDialog({
                                title = string.format("%s - Version %s", mod.title, versionString),
                                text = text,
                                dialogType = DialogElement.TYPE_LOADING,
                                callback = self.openModHubLink,
                                target = nil,
                                yesText = g_i18n:getText("button_ok"),
                                noText = g_i18n:getText("button_modHubDownload")
                            })
                        end
                    else
                        print("\n" .. text .. "\n    - https://farming-simulator.com/mods.php?lang=en&country=be&title=fs2022&filter=org&org_id=129652&page=0" .. "\n")
                        self.openModHubLink(true)
                    end
                end
            end,

            openModHubLink = function(ignore)
                if ignore == false then
                    local language = g_languageShort
                    local link = "mods.php?lang=en&country=be&title=fs2022&filter=org&org_id=129652&page=0"
                    if language == "de" or language == "fr" then
                        link = "mods.php?lang=" .. language .. "&country=be&title=fs2022&filter=org&org_id=129652&page=0"
                    end

                    openWebFile(link, "")
                end

                removeModEventListener(validationFail)
                validationFail = nil
            end
        }

        addModEventListener(validationFail)
    end
end

init()
